<?php

if(!class_exists('Vc_Manager')) return;

// Add Simple Line font Icon
if ( !function_exists('urna_tbay_add_simple_line_icon_set_to_iconbox')) {
    function urna_tbay_add_simple_line_icon_set_to_iconbox( ) {
        $param = WPBMap::getParam( 'vc_icon', 'type' );
        $param['value'][esc_html__( 'Simple Line', 'urna' )] = 'simpleline';
        $param['weight'] = 90;
        vc_update_shortcode_param( 'vc_icon', $param );
    }
    add_filter( 'init', 'urna_tbay_add_simple_line_icon_set_to_iconbox', 40 );
}

// Add Simple Line font Icon
if ( !function_exists('urna_tbay_add_linearicons_set_to_iconbox')) {
    function urna_tbay_add_linearicons_set_to_iconbox( ) {
        $param = WPBMap::getParam( 'vc_icon', 'type' );
        $param['value'][esc_html__( 'linear Icons', 'urna' )] = 'linearicons';
        $param['weight'] = 90;
        vc_update_shortcode_param( 'vc_icon', $param );
    }
    add_filter( 'init', 'urna_tbay_add_linearicons_set_to_iconbox', 50 );
}

// Add font picker setting to icon box module when you select your font family from the dropdown
if ( !function_exists('urna_tbay_add_font_picker')) {
    function urna_tbay_add_font_picker() {
        vc_add_param( 'vc_icon', array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'urna' ),
                'param_name' => 'icon_simpleline',
                'settings' => array(
                    'emptyIcon' => true,
                    'type' => 'simpleline',
                    'iconsPerPage' => 400,
                ),
                'value' => 'icon-user',
                'weight' => 80,
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'simpleline',
                ),
            )
        );
        vc_add_param( 'vc_icon', array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'urna' ),
                'param_name' => 'icon_linearicons',
                'settings' => array(
                    'emptyIcon' => true,
                    'type' => 'linearicons',
                    'iconsPerPage' => 400,
                ),
                'value' => 'linear-icon-home',
                'weight' => 80,
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'linearicons',
                ),
            )
        );
    }
    add_filter( 'vc_after_init', 'urna_tbay_add_font_picker', 40 );
}
// Add array of your fonts so they can be displayed in the font selector
if ( !function_exists('urna_tbay_icon_array')) {
    function urna_tbay_icon_array() {
        return array(
            array('icon-user'                           => 'user'),
            array('icon-people'                         => 'people'),
            array('icon-user-female'                => 'user female'),
            array('icon-user-follow'                => 'user follow'),
            array('icon-user-following'         => 'user following'),
            array('icon-login'                          => 'login'),
            array('icon-logout'                         => 'logout'),
            array('icon-emotsmile'                  => 'emotsmile'),
            array('icon-phone'                          => 'phone'),
            array('icon-call-end'                   => 'call end'),
            array('icon-call-in'                        => 'call in'),
            array('icon-call-out'                       => 'call out'),
            array('icon-map'                                => 'call map'),
            array('icon-location-pin'           => 'location pin'),
            array('icon-direction'                  => 'direction'),
            array('icon-directions'                 => 'directions'),
            array('icon-compass'                        => 'compass'),
            array('icon-layers'                         => 'layers'),
            array('icon-list'                           => 'list'),
            array('icon-options-vertical'   => 'options vertical'),
            array('icon-options'                        => 'options'),
            array('icon-arrow-down'                 => 'arrow down'),
            array('icon-arrow-left'                 => 'arrow left'),
            array('icon-arrow-right'                => 'arrow right'),
            array('icon-arrow-up'                   => 'arrow up'),
            array('icon-arrow-up-circle'        => 'arrow up circle'),
            array('icon-arrow-left-circle'  => 'arrow left circle'),
            array('icon-arrow-right-circle' => 'arrow right circle'),
            array('icon-arrow-down-circle'  => 'arrow down circle'),
            array('icon-check'                          => 'check'),
            array('icon-clock'                          => 'clock'),
            array('icon-plus'                           => 'plus'),
            array('icon-minus'                          => 'minus'),
            array('icon-close'                          => 'close'),
            array('icon-event'                          => 'event'),
            array('icon-exclamation'                => 'exclamation'),
            array('icon-organization'           => 'organization'),
            array('icon-trophy'                         => 'trophy'),
            array('icon-screen-smartphone'  => 'screen smartphone'),
            array('icon-screen-desktop'         => 'screen desktop'),
            array('icon-plane'                          => 'plane'),
            array('icon-notebook'                   => 'notebook'),
            array('icon-mustache'                   => 'mustache'),
            array('icon-mouse'                          => 'mouse'),
            array('icon-magnet'                         => 'magnet'),
            array('icon-energy'                         => 'energy'),
            array('icon-disc'                           => 'disc'),
            array('icon-cursor'                         => 'cursor'),
            array('icon-cursor-move'                => 'cursor move'),
            array('icon-crop'                           => 'crop'),
            array('icon-chemistry'                  => 'chemistry'),
            array('icon-speedometer'                => 'speedometer'),
            array('icon-shield'                         => 'shield'),
            array('icon-screen-tablet'          => 'screen tablet'),
            array('icon-magic-wand'                 => 'magic wand'),
            array('icon-hourglass'                  => 'hourglass'),
            array('icon-graduation'                 => 'graduation'),
            array('icon-ghost'                          => 'ghost'),
            array('icon-game-controller'        => 'game controller'),
            array('icon-fire'                           => 'fire'),
            array('icon-eyeglass'                   => 'eyeglass'),
            array('icon-envelope-open'          => 'envelope open'),
            array('icon-envelope-letter'        => 'envelope letter'),
            array('icon-bell'                           => 'bell'),
            array('icon-badge'                          => 'badge'),
            array('icon-anchor'                         => 'anchor'),
            array('icon-wallet'                         => 'wallet'),
            array('icon-vector'                         => 'vector'),
            array('icon-speech'                         => 'speech'),
            array('icon-puzzle'                         => 'puzzle'),
            array('icon-printer'                        => 'printer'),
            array('icon-present'                        => 'present'),
            array('icon-playlist'                   => 'playlist'),
            array('icon-pin'                                => 'pin'),
            array('icon-picture'                        => 'picture'),
            array('icon-handbag'                        => 'handbag'),
            array('icon-globe-alt'                  => 'globe alt'),
            array('icon-globe'                          => 'globe'),
            array('icon-folder-alt'                 => 'folder alt'),
            array('icon-folder'                         => 'folder'),
            array('icon-film'                           => 'film'),
            array('icon-feed'                           => 'feed'),
            array('icon-drop'                           => 'drop'),
            array('icon-drawer'                         => 'drawer'),
            array('icon-docs'                           => 'docs'),
            array('icon-doc'                                => 'doc'),
            array('icon-diamond'                        => 'diamond'),
            array('icon-cup'                                => 'cup'),
            array('icon-calculator'                 => 'calculator'),
            array('icon-bubbles'                        => 'bubbles'),
            array('icon-briefcase'                  => 'briefcase'),
            array('icon-book-open'                  => 'book open'),
            array('icon-basket-loaded'          => 'basket loaded'),
            array('icon-basket'                         => 'basket'),
            array('icon-bag'                                => 'bag'),
            array('icon-action-undo'                => 'action undo'),
            array('icon-action-redo'                => 'action redo'),
            array('icon-wrench'                         => 'wrench'),
            array('icon-umbrella'                   => 'umbrella'),
            array('icon-trash'                          => 'trash'),
            array('icon-tag'                                => 'tag'),
            array('icon-support'                        => 'support'),
            array('icon-frame'                          => 'frame'),
            array('icon-size-fullscreen'        => 'size fullscreen'),
            array('icon-size-actual'                => 'size actual'),
            array('icon-shuffle'                        => 'shuffle'),
            array('icon-share-alt'                  => 'share alt'),
            array('icon-share'                          => 'share'),
            array('icon-rocket'                         => 'rocket'),
            array('icon-question'                   => 'question'),
            array('icon-pie-chart'                  => 'pie chart'),
            array('icon-pencil'                         => 'pencil'),
            array('icon-note'                           => 'note'),
            array('icon-loop'                           => 'loop'),
            array('icon-home'                           => 'home'),
            array('icon-grid'                           => 'grid'),
            array('icon-graph'                          => 'graph'),
            array('icon-microphone'                 => 'microphone'),
            array('icon-music-tone-alt'         => 'music tone alt'),
            array('icon-music-tone'                 => 'music tone'),
            array('icon-earphones-alt'          => 'earphones alt'),
            array('icon-earphones'                  => 'earphones'),
            array('icon-equalizer'                  => 'equalizer'),
            array('icon-like'                           => 'like'),
            array('icon-dislike'                        => 'dislike'),
            array('icon-control-start'          => 'control start'),
            array('icon-control-rewind'         => 'control rewind'),
            array('icon-control-play'           => 'control play'),
            array('icon-control-pause'          => 'control pause'),
            array('icon-control-forward'        => 'control forward'),
            array('icon-control-end'                => 'control end'),
            array('icon-control-end'                => 'control end'),
            array('icon-volume-1'                   => 'volume 1'),
            array('icon-volume-2'                   => 'volume 2'),
            array('icon-volume-off'                 => 'volume off'),
            array('icon-calendar'                   => 'calendar'),
            array('icon-bulb'                           => 'bulb'),
            array('icon-chart'                          => 'chart'),
            array('icon-ban'                                => 'ban'),
            array('icon-bubble'                         => 'bubble'),
            array('icon-camrecorder'                => 'camrecorder'),
            array('icon-camera'                         => 'camera'),
            array('icon-cloud-download'         => 'cloud download'),
            array('icon-cloud-upload'           => 'cloud upload'),
            array('icon-envelope'                       => 'envelope'),
            array('icon-eye'                                => 'eye'),
            array('icon-flag'                           => 'flag'),
            array('icon-heart'                          => 'heart'),
            array('icon-info'                           => 'info'),
            array('icon-key'                                => 'key'),
            array('icon-link'                               => 'link'),
            array('icon-lock'                           => 'lock'),
            array('icon-lock-open'                  => 'lock open'),
            array('icon-magnifier'                  => 'magnifier'),
            array('icon-magnifier-add'          => 'magnifier add'),
            array('icon-magnifier-remove'   => 'magnifier remove'),
            array('icon-paper-clip'                 => 'paper clip'),
            array('icon-paper-plane'                => 'paper plane'),
            array('icon-power'                          => 'power'),
            array('icon-refresh'                        => 'refresh'),
            array('icon-reload'                         => 'reload'),
            array('icon-settings'                   => 'settings'),
            array('icon-symbol-female'          => 'symbol female'),
            array('icon-symbol-male'                => 'symbol male'),
            array('icon-target'                         => 'target'),
            array('icon-credit-card'                => 'credit card'),
            array('icon-paypal'                         => 'paypal'),
            array('icon-social-tumblr'          => 'social tumblr'),
            array('icon-social-twitter'         => 'social twitter'),
            array('icon-social-facebook'        => 'social facebook'),
            array('icon-social-instagram'   => 'social instagram'),
            array('icon-social-linkedin'        => 'social linkedin'),
            array('icon-social-pinterest'   => 'social pinterest'),
            array('icon-social-github'          => 'social github'),
            array('icon-social-google'          => 'social google'),
            array('icon-social-reddit'          => 'social reddit'),
            array('icon-social-skype'           => 'social skype'),
            array('icon-social-skype'           => 'social skype'),
            array('icon-social-behance'         => 'social behance'),
            array('icon-social-foursqare'   => 'social foursqare'),
            array('icon-social-soundcloud'  => 'social soundcloud'),
            array('icon-social-stumbleupon' => 'social stumbleupon'),
            array('icon-social-youtube'         => 'social youtube'),
            array('icon-social-vkontakte'   => 'social vkontakte'),
            array('icon-social-steam'           => 'social steam'),
        );
    }
    add_filter( 'vc_iconpicker-type-simpleline', 'urna_tbay_icon_array' );
}

if ( !function_exists('urna_tbay_linearicons_array')) {
    function urna_tbay_linearicons_array() {
        return array(
            array('linear-icon-home' => 'home'),
            array('linear-icon-home2' => 'home2'),
            array('linear-icon-home3' => 'home3'),
            array('linear-icon-home4' => 'home4'),
            array('linear-icon-home5' => 'home5'),
            array('linear-icon-home6' => 'home6'),
            array('linear-icon-bathtub' => 'bathtub'),
            array('linear-icon-toothbrush' => 'toothbrush'),
            array('linear-icon-bed' => 'bed'),
            array('linear-icon-couch' => 'couch'),
            array('linear-icon-chair' => 'chair'),
            array('linear-icon-city' => 'city'),
            array('linear-icon-apartment' => 'apartment'),
            array('linear-icon-pencil' => 'pencil'),
            array('linear-icon-pencil2' => 'pencil2'),
            array('linear-icon-pen' => 'pen'),
            array('linear-icon-pencil3' => 'pencil3'),
            array('linear-icon-eraser' => 'eraser'),
            array('linear-icon-pencil4' => 'pencil4'),
            array('linear-icon-pencil5' => 'pencil5'),
            array('linear-icon-feather' => 'feather'),
            array('linear-icon-feather2' => 'feather2'),
            array('linear-icon-feather3' => 'feather3'),
            array('linear-icon-pen2' => 'pen2'),
            array('linear-icon-pen-add' => 'pen-add'),
            array('linear-icon-pen-remove' => 'pen-remove'),
            array('linear-icon-vector' => 'vector'),
            array('linear-icon-pen3' => 'pen3'),
            array('linear-icon-blog' => 'blog'),
            array('linear-icon-brush' => 'brush'),
            array('linear-icon-brush2' => 'brush2'),
            array('linear-icon-spray' => 'spray'),
            array('linear-icon-paint-roller' => 'paint-roller'),
            array('linear-icon-stamp' => 'stamp'),
            array('linear-icon-tape' => 'tape'),
            array('linear-icon-desk-tape' => 'desk-tape'),
            array('linear-icon-texture' => 'texture'),
            array('linear-icon-eye-dropper' => 'eye-dropper'),
            array('linear-icon-palette' => 'palette'),
            array('linear-icon-color-sampler' => 'color-sampler'),
            array('linear-icon-bucket' => 'bucket'),
            array('linear-icon-gradient' => 'gradient'),
            array('linear-icon-gradient2' => 'gradient2'),
            array('linear-icon-magic-wand' => 'magic-wand'),
            array('linear-icon-magnet' => 'magnet'),
            array('linear-icon-pencil-ruler' => 'pencil-ruler'),
            array('linear-icon-pencil-ruler2' => 'pencil-ruler2'),
            array('linear-icon-compass' => 'compass'),
            array('linear-icon-aim' => 'aim'),
            array('linear-icon-gun' => 'gun'),
            array('linear-icon-bottle' => 'bottle'),
            array('linear-icon-drop' => 'drop'),
            array('linear-icon-drop-crossed' => 'drop-crossed'),
            array('linear-icon-drop2' => 'drop2'),
            array('linear-icon-snow' => 'snow'),
            array('linear-icon-snow2' => 'snow2'),
            array('linear-icon-fire' => 'fire'),
            array('linear-icon-lighter' => 'lighter'),
            array('linear-icon-knife' => 'knife'),
            array('linear-icon-dagger' => 'dagger'),
            array('linear-icon-tissue' => 'tissue'),
            array('linear-icon-toilet-paper' => 'toilet-paper'),
            array('linear-icon-poop' => 'poop'),
            array('linear-icon-umbrella' => 'umbrella'),
            array('linear-icon-umbrella2' => 'umbrella2'),
            array('linear-icon-rain' => 'rain'),
            array('linear-icon-tornado' => 'tornado'),
            array('linear-icon-wind' => 'wind'),
            array('linear-icon-fan' => 'fan'),
            array('linear-icon-contrast' => 'contrast'),
            array('linear-icon-sun-small' => 'sun-small'),
            array('linear-icon-sun' => 'sun'),
            array('linear-icon-sun2' => 'sun2'),
            array('linear-icon-moon' => 'moon'),
            array('linear-icon-cloud' => 'cloud'),
            array('linear-icon-cloud-upload' => 'cloud-upload'),
            array('linear-icon-cloud-download' => 'cloud-download'),
            array('linear-icon-cloud-rain' => 'cloud-rain'),
            array('linear-icon-cloud-hailstones' => 'cloud-hailstones'),
            array('linear-icon-cloud-snow' => 'cloud-snow'),
            array('linear-icon-cloud-windy' => 'cloud-windy'),
            array('linear-icon-sun-wind' => 'sun-wind'),
            array('linear-icon-cloud-fog' => 'cloud-fog'),
            array('linear-icon-cloud-sun' => 'cloud-sun'),
            array('linear-icon-cloud-lightning' => 'cloud-lightning'),
            array('linear-icon-cloud-sync' => 'cloud-sync'),
            array('linear-icon-cloud-lock' => 'cloud-lock'),
            array('linear-icon-cloud-gear' => 'cloud-gear'),
            array('linear-icon-cloud-alert' => 'cloud-alert'),
            array('linear-icon-cloud-check' => 'cloud-check'),
            array('linear-icon-cloud-cross' => 'cloud-cross'),
            array('linear-icon-cloud-crossed' => 'cloud-crossed'),
            array('linear-icon-cloud-database' => 'cloud-database'),
            array('linear-icon-database' => 'database'),
            array('linear-icon-database-add' => 'database-add'),
            array('linear-icon-database-remove' => 'database-remove'),
            array('linear-icon-database-lock' => 'database-lock'),
            array('linear-icon-database-refresh' => 'database-refresh'),
            array('linear-icon-database-check' => 'database-check'),
            array('linear-icon-database-history' => 'database-history'),
            array('linear-icon-database-upload' => 'database-upload'),
            array('linear-icon-database-download' => 'database-download'),
            array('linear-icon-server' => 'server'),
            array('linear-icon-shield' => 'shield'),
            array('linear-icon-shield-check' => 'shield-check'),
            array('linear-icon-shield-alert' => 'shield-alert'),
            array('linear-icon-shield-cross' => 'shield-cross'),
            array('linear-icon-lock' => 'lock'),
            array('linear-icon-rotation-lock' => 'rotation-lock'),
            array('linear-icon-unlock' => 'unlock'),
            array('linear-icon-key' => 'key'),
            array('linear-icon-key-hole' => 'key-hole'),
            array('linear-icon-toggle-off' => 'toggle-off'),
            array('linear-icon-toggle-on' => 'toggle-on'),
            array('linear-icon-cog' => 'cog'),
            array('linear-icon-cog2' => 'cog2'),
            array('linear-icon-wrench' => 'wrench'),
            array('linear-icon-screwdriver' => 'screwdriver'),
            array('linear-icon-hammer-wrench' => 'hammer-wrench'),
            array('linear-icon-hammer' => 'hammer'),
            array('linear-icon-saw' => 'saw'),
            array('linear-icon-axe' => 'axe'),
            array('linear-icon-axe2' => 'axe2'),
            array('linear-icon-shovel' => 'shovel'),
            array('linear-icon-pickaxe' => 'pickaxe'),
            array('linear-icon-factory' => 'factory'),
            array('linear-icon-factory2' => 'factory2'),
            array('linear-icon-recycle' => 'recycle'),
            array('linear-icon-trash' => 'trash'),
            array('linear-icon-trash2' => 'trash2'),
            array('linear-icon-trash3' => 'trash3'),
            array('linear-icon-broom' => 'broom'),
            array('linear-icon-game' => 'game'),
            array('linear-icon-gamepad' => 'gamepad'),
            array('linear-icon-joystick' => 'joystick'),
            array('linear-icon-dice' => 'dice'),
            array('linear-icon-spades' => 'spades'),
            array('linear-icon-diamonds' => 'diamonds'),
            array('linear-icon-clubs' => 'clubs'),
            array('linear-icon-hearts' => 'hearts'),
            array('linear-icon-heart' => 'heart'),
            array('linear-icon-star' => 'star'),
            array('linear-icon-star-half' => 'star-half'),
            array('linear-icon-star-empty' => 'star-empty'),
            array('linear-icon-flag' => 'flag'),
            array('linear-icon-flag2' => 'flag2'),
            array('linear-icon-flag3' => 'flag3'),
            array('linear-icon-mailbox-full' => 'mailbox-full'),
            array('linear-icon-mailbox-empty' => 'mailbox-empty'),
            array('linear-icon-at-sign' => 'at-sign'),
            array('linear-icon-envelope' => 'envelope'),
            array('linear-icon-envelope-open' => 'envelope-open'),
            array('linear-icon-paperclip' => 'paperclip'),
            array('linear-icon-paper-plane' => 'paper-plane'),
            array('linear-icon-reply' => 'reply'),
            array('linear-icon-reply-all' => 'reply-all'),
            array('linear-icon-inbox' => 'inbox'),
            array('linear-icon-inbox2' => 'inbox2'),
            array('linear-icon-outbox' => 'outbox'),
            array('linear-icon-box' => 'box'),
            array('linear-icon-archive' => 'archive'),
            array('linear-icon-archive2' => 'archive2'),
            array('linear-icon-drawers' => 'drawers'),
            array('linear-icon-drawers2' => 'drawers2'),
            array('linear-icon-drawers3' => 'drawers3'),
            array('linear-icon-eye' => 'eye'),
            array('linear-icon-eye-crossed' => 'eye-crossed'),
            array('linear-icon-eye-plus' => 'eye-plus'),
            array('linear-icon-eye-minus' => 'eye-minus'),
            array('linear-icon-binoculars' => 'binoculars'),
            array('linear-icon-binoculars2' => 'binoculars2'),
            array('linear-icon-hdd' => 'hdd'),
            array('linear-icon-hdd-down' => 'hdd-down'),
            array('linear-icon-hdd-up' => 'hdd-up'),
            array('linear-icon-floppy-disk' => 'floppy-disk'),
            array('linear-icon-disc' => 'disc'),
            array('linear-icon-tape2' => 'tape2'),
            array('linear-icon-printer' => 'printer'),
            array('linear-icon-shredder' => 'shredder'),
            array('linear-icon-file-empty' => 'file-empty'),
            array('linear-icon-file-add' => 'file-add'),
            array('linear-icon-file-check' => 'file-check'),
            array('linear-icon-file-lock' => 'file-lock'),
            array('linear-icon-files' => 'files'),
            array('linear-icon-copy' => 'copy'),
            array('linear-icon-compare' => 'compare'),
            array('linear-icon-folder' => 'folder'),
            array('linear-icon-folder-search' => 'folder-search'),
            array('linear-icon-folder-plus' => 'folder-plus'),
            array('linear-icon-folder-minus' => 'folder-minus'),
            array('linear-icon-folder-download' => 'folder-download'),
            array('linear-icon-folder-upload' => 'folder-upload'),
            array('linear-icon-folder-star' => 'folder-star'),
            array('linear-icon-folder-heart' => 'folder-heart'),
            array('linear-icon-folder-user' => 'folder-user'),
            array('linear-icon-folder-shared' => 'folder-shared'),
            array('linear-icon-folder-music' => 'folder-music'),
            array('linear-icon-folder-picture' => 'folder-picture'),
            array('linear-icon-folder-film' => 'folder-film'),
            array('linear-icon-scissors' => 'scissors'),
            array('linear-icon-paste' => 'paste'),
            array('linear-icon-clipboard-empty' => 'clipboard-empty'),
            array('linear-icon-clipboard-pencil' => 'clipboard-pencil'),
            array('linear-icon-clipboard-text' => 'clipboard-text'),
            array('linear-icon-clipboard-check' => 'clipboard-check'),
            array('linear-icon-clipboard-down' => 'clipboard-down'),
            array('linear-icon-clipboard-left' => 'clipboard-left'),
            array('linear-icon-clipboard-alert' => 'clipboard-alert'),
            array('linear-icon-clipboard-user' => 'clipboard-user'),
            array('linear-icon-register' => 'register'),
            array('linear-icon-enter' => 'enter'),
            array('linear-icon-exit' => 'exit'),
            array('linear-icon-papers' => 'papers'),
            array('linear-icon-news' => 'news'),
            array('linear-icon-reading' => 'reading'),
            array('linear-icon-typewriter' => 'typewriter'),
            array('linear-icon-document' => 'document'),
            array('linear-icon-document2' => 'document2'),
            array('linear-icon-graduation-hat' => 'graduation-hat'),
            array('linear-icon-license' => 'license'),
            array('linear-icon-license2' => 'license2'),
            array('linear-icon-medal-empty' => 'medal-empty'),
            array('linear-icon-medal-first' => 'medal-first'),
            array('linear-icon-medal-second' => 'medal-second'),
            array('linear-icon-medal-third' => 'medal-third'),
            array('linear-icon-podium' => 'podium'),
            array('linear-icon-trophy' => 'trophy'),
            array('linear-icon-trophy2' => 'trophy2'),
            array('linear-icon-music-note' => 'music-note'),
            array('linear-icon-music-note2' => 'music-note2'),
            array('linear-icon-music-note3' => 'music-note3'),
            array('linear-icon-playlist' => 'playlist'),
            array('linear-icon-playlist-add' => 'playlist-add'),
            array('linear-icon-guitar' => 'guitar'),
            array('linear-icon-trumpet' => 'trumpet'),
            array('linear-icon-album' => 'album'),
            array('linear-icon-shuffle' => 'shuffle'),
            array('linear-icon-repeat-one' => 'repeat-one'),
            array('linear-icon-repeat' => 'repeat'),
            array('linear-icon-headphones' => 'headphones'),
            array('linear-icon-headset' => 'headset'),
            array('linear-icon-loudspeaker' => 'loudspeaker'),
            array('linear-icon-equalizer' => 'equalizer'),
            array('linear-icon-theater' => 'theater'),
            array('linear-icon-3d-glasses' => '3d-glasses'),
            array('linear-icon-ticket' => 'ticket'),
            array('linear-icon-presentation' => 'presentation'),
            array('linear-icon-play' => 'play'),
            array('linear-icon-film-play' => 'film-play'),
            array('linear-icon-clapboard-play' => 'clapboard-play'),
            array('linear-icon-media' => 'media'),
            array('linear-icon-film' => 'film'),
            array('linear-icon-film2' => 'film2'),
            array('linear-icon-surveillance' => 'surveillance'),
            array('linear-icon-surveillance2' => 'surveillance2'),
            array('linear-icon-camera' => 'camera'),
            array('linear-icon-camera-crossed' => 'camera-crossed'),
            array('linear-icon-camera-play' => 'camera-play'),
            array('linear-icon-time-lapse' => 'time-lapse'),
            array('linear-icon-record' => 'record'),
            array('linear-icon-camera2' => 'camera2'),
            array('linear-icon-camera-flip' => 'camera-flip'),
            array('linear-icon-panorama' => 'panorama'),
            array('linear-icon-time-lapse2' => 'time-lapse2'),
            array('linear-icon-shutter' => 'shutter'),
            array('linear-icon-shutter2' => 'shutter2'),
            array('linear-icon-face-detection' => 'face-detection'),
            array('linear-icon-flare' => 'flare'),
            array('linear-icon-convex' => 'convex'),
            array('linear-icon-concave' => 'concave'),
            array('linear-icon-picture' => 'picture'),
            array('linear-icon-picture2' => 'picture2'),
            array('linear-icon-picture3' => 'picture3'),
            array('linear-icon-pictures' => 'pictures'),
            array('linear-icon-book' => 'book'),
            array('linear-icon-audio-book' => 'audio-book'),
            array('linear-icon-book2' => 'book2'),
            array('linear-icon-bookmark' => 'bookmark'),
            array('linear-icon-bookmark2' => 'bookmark2'),
            array('linear-icon-label' => 'label'),
            array('linear-icon-library' => 'library'),
            array('linear-icon-library2' => 'library2'),
            array('linear-icon-contacts' => 'contacts'),
            array('linear-icon-profile' => 'profile'),
            array('linear-icon-portrait' => 'portrait'),
            array('linear-icon-portrait2' => 'portrait2'),
            array('linear-icon-user' => 'user'),
            array('linear-icon-user-plus' => 'user-plus'),
            array('linear-icon-user-minus' => 'user-minus'),
            array('linear-icon-user-lock' => 'user-lock'),
            array('linear-icon-users' => 'users'),
            array('linear-icon-users2' => 'users2'),
            array('linear-icon-users-plus' => 'users-plus'),
            array('linear-icon-users-minus' => 'users-minus'),
            array('linear-icon-group-work' => 'group-work'),
            array('linear-icon-woman' => 'woman'),
            array('linear-icon-man' => 'man'),
            array('linear-icon-baby' => 'baby'),
            array('linear-icon-baby2' => 'baby2'),
            array('linear-icon-baby3' => 'baby3'),
            array('linear-icon-baby-bottle' => 'baby-bottle'),
            array('linear-icon-walk' => 'walk'),
            array('linear-icon-hand-waving' => 'hand-waving'),
            array('linear-icon-jump' => 'jump'),
            array('linear-icon-run' => 'run'),
            array('linear-icon-woman2' => 'woman2'),
            array('linear-icon-man2' => 'man2'),
            array('linear-icon-man-woman' => 'man-woman'),
            array('linear-icon-height' => 'height'),
            array('linear-icon-weight' => 'weight'),
            array('linear-icon-scale' => 'scale'),
            array('linear-icon-button' => 'button'),
            array('linear-icon-bow-tie' => 'bow-tie'),
            array('linear-icon-tie' => 'tie'),
            array('linear-icon-socks' => 'socks'),
            array('linear-icon-shoe' => 'shoe'),
            array('linear-icon-shoes' => 'shoes'),
            array('linear-icon-hat' => 'hat'),
            array('linear-icon-pants' => 'pants'),
            array('linear-icon-shorts' => 'shorts'),
            array('linear-icon-flip-flops' => 'flip-flops'),
            array('linear-icon-shirt' => 'shirt'),
            array('linear-icon-hanger' => 'hanger'),
            array('linear-icon-laundry' => 'laundry'),
            array('linear-icon-store' => 'store'),
            array('linear-icon-haircut' => 'haircut'),
            array('linear-icon-store-24' => 'store-24'),
            array('linear-icon-barcode' => 'barcode'),
            array('linear-icon-barcode2' => 'barcode2'),
            array('linear-icon-barcode3' => 'barcode3'),
            array('linear-icon-cashier' => 'cashier'),
            array('linear-icon-bag' => 'bag'),
            array('linear-icon-bag2' => 'bag2'),
            array('linear-icon-cart' => 'cart'),
            array('linear-icon-cart-empty' => 'cart-empty'),
            array('linear-icon-cart-full' => 'cart-full'),
            array('linear-icon-cart-plus' => 'cart-plus'),
            array('linear-icon-cart-plus2' => 'cart-plus2'),
            array('linear-icon-cart-add' => 'cart-add'),
            array('linear-icon-cart-remove' => 'cart-remove'),
            array('linear-icon-cart-exchange' => 'cart-exchange'),
            array('linear-icon-tag' => 'tag'),
            array('linear-icon-tags' => 'tags'),
            array('linear-icon-receipt' => 'receipt'),
            array('linear-icon-wallet' => 'wallet'),
            array('linear-icon-credit-card' => 'credit-card'),
            array('linear-icon-cash-dollar' => 'cash-dollar'),
            array('linear-icon-cash-euro' => 'cash-euro'),
            array('linear-icon-cash-pound' => 'cash-pound'),
            array('linear-icon-cash-yen' => 'cash-yen'),
            array('linear-icon-bag-dollar' => 'bag-dollar'),
            array('linear-icon-bag-euro' => 'bag-euro'),
            array('linear-icon-bag-pound' => 'bag-pound'),
            array('linear-icon-bag-yen' => 'bag-yen'),
            array('linear-icon-coin-dollar' => 'coin-dollar'),
            array('linear-icon-coin-euro' => 'coin-euro'),
            array('linear-icon-coin-pound' => 'coin-pound'),
            array('linear-icon-coin-yen' => 'coin-yen'),
            array('linear-icon-calculator' => 'calculator'),
            array('linear-icon-calculator2' => 'calculator2'),
            array('linear-icon-abacus' => 'abacus'),
            array('linear-icon-vault' => 'vault'),
            array('linear-icon-telephone' => 'telephone'),
            array('linear-icon-phone-lock' => 'phone-lock'),
            array('linear-icon-phone-wave' => 'phone-wave'),
            array('linear-icon-phone-pause' => 'phone-pause'),
            array('linear-icon-phone-outgoing' => 'phone-outgoing'),
            array('linear-icon-phone-incoming' => 'phone-incoming'),
            array('linear-icon-phone-in-out' => 'phone-in-out'),
            array('linear-icon-phone-error' => 'phone-error'),
            array('linear-icon-phone-sip' => 'phone-sip'),
            array('linear-icon-phone-plus' => 'phone-plus'),
            array('linear-icon-phone-minus' => 'phone-minus'),
            array('linear-icon-voicemail' => 'voicemail'),
            array('linear-icon-dial' => 'dial'),
            array('linear-icon-telephone2' => 'telephone2'),
            array('linear-icon-pushpin' => 'pushpin'),
            array('linear-icon-pushpin2' => 'pushpin2'),
            array('linear-icon-map-marker' => 'map-marker'),
            array('linear-icon-map-marker-user' => 'map-marker-user'),
            array('linear-icon-map-marker-down' => 'map-marker-down'),
            array('linear-icon-map-marker-check' => 'map-marker-check'),
            array('linear-icon-map-marker-crossed' => 'map-marker-crossed'),
            array('linear-icon-radar' => 'radar'),
            array('linear-icon-compass2' => 'compass2'),
            array('linear-icon-map' => 'map'),
            array('linear-icon-map2' => 'map2'),
            array('linear-icon-location' => 'location'),
            array('linear-icon-road-sign' => 'road-sign'),
            array('linear-icon-calendar-empty' => 'calendar-empty'),
            array('linear-icon-calendar-check' => 'calendar-check'),
            array('linear-icon-calendar-cross' => 'calendar-cross'),
            array('linear-icon-calendar-31' => 'calendar-31'),
            array('linear-icon-calendar-full' => 'calendar-full'),
            array('linear-icon-calendar-insert' => 'calendar-insert'),
            array('linear-icon-calendar-text' => 'calendar-text'),
            array('linear-icon-calendar-user' => 'calendar-user'),
            array('linear-icon-mouse' => 'mouse'),
            array('linear-icon-mouse-left' => 'mouse-left'),
            array('linear-icon-mouse-right' => 'mouse-right'),
            array('linear-icon-mouse-both' => 'mouse-both'),
            array('linear-icon-keyboard' => 'keyboard'),
            array('linear-icon-keyboard-up' => 'keyboard-up'),
            array('linear-icon-keyboard-down' => 'keyboard-down'),
            array('linear-icon-delete' => 'delete'),
            array('linear-icon-spell-check' => 'spell-check'),
            array('linear-icon-escape' => 'escape'),
            array('linear-icon-enter2' => 'enter2'),
            array('linear-icon-screen' => 'screen'),
            array('linear-icon-aspect-ratio' => 'aspect-ratio'),
            array('linear-icon-signal' => 'signal'),
            array('linear-icon-signal-lock' => 'signal-lock'),
            array('linear-icon-signal-80' => 'signal-80'),
            array('linear-icon-signal-60' => 'signal-60'),
            array('linear-icon-signal-40' => 'signal-40'),
            array('linear-icon-signal-20' => 'signal-20'),
            array('linear-icon-signal-0' => 'signal-0'),
            array('linear-icon-signal-blocked' => 'signal-blocked'),
            array('linear-icon-sim' => 'sim'),
            array('linear-icon-flash-memory' => 'flash-memory'),
            array('linear-icon-usb-drive' => 'usb-drive'),
            array('linear-icon-phone' => 'phone'),
            array('linear-icon-smartphone' => 'smartphone'),
            array('linear-icon-smartphone-notification' => 'smartphone-notification'),
            array('linear-icon-smartphone-vibration' => 'smartphone-vibration'),
            array('linear-icon-smartphone-embed' => 'smartphone-embed'),
            array('linear-icon-smartphone-waves' => 'smartphone-waves'),
            array('linear-icon-tablet' => 'tablet'),
            array('linear-icon-tablet2' => 'tablet2'),
            array('linear-icon-laptop' => 'laptop'),
            array('linear-icon-laptop-phone' => 'laptop-phone'),
            array('linear-icon-desktop' => 'desktop'),
            array('linear-icon-launch' => 'launch'),
            array('linear-icon-new-tab' => 'new-tab'),
            array('linear-icon-window' => 'window'),
            array('linear-icon-cable' => 'cable'),
            array('linear-icon-cable2' => 'cable2'),
            array('linear-icon-tv' => 'tv'),
            array('linear-icon-radio' => 'radio'),
            array('linear-icon-remote-control' => 'remote-control'),
            array('linear-icon-power-switch' => 'power-switch'),
            array('linear-icon-power' => 'power'),
            array('linear-icon-power-crossed' => 'power-crossed'),
            array('linear-icon-flash-auto' => 'flash-auto'),
            array('linear-icon-lamp' => 'lamp'),
            array('linear-icon-flashlight' => 'flashlight'),
            array('linear-icon-lampshade' => 'lampshade'),
            array('linear-icon-cord' => 'cord'),
            array('linear-icon-outlet' => 'outlet'),
            array('linear-icon-battery-power' => 'battery-power'),
            array('linear-icon-battery-empty' => 'battery-empty'),
            array('linear-icon-battery-alert' => 'battery-alert'),
            array('linear-icon-battery-error' => 'battery-error'),
            array('linear-icon-battery-low1' => 'battery-low1'),
            array('linear-icon-battery-low2' => 'battery-low2'),
            array('linear-icon-battery-low3' => 'battery-low3'),
            array('linear-icon-battery-mid1' => 'battery-mid1'),
            array('linear-icon-battery-mid2' => 'battery-mid2'),
            array('linear-icon-battery-mid3' => 'battery-mid3'),
            array('linear-icon-battery-full' => 'battery-full'),
            array('linear-icon-battery-charging' => 'battery-charging'),
            array('linear-icon-battery-charging2' => 'battery-charging2'),
            array('linear-icon-battery-charging3' => 'battery-charging3'),
            array('linear-icon-battery-charging4' => 'battery-charging4'),
            array('linear-icon-battery-charging5' => 'battery-charging5'),
            array('linear-icon-battery-charging6' => 'battery-charging6'),
            array('linear-icon-battery-charging7' => 'battery-charging7'),
            array('linear-icon-chip' => 'chip'),
            array('linear-icon-chip-x64' => 'chip-x64'),
            array('linear-icon-chip-x86' => 'chip-x86'),
            array('linear-icon-bubble' => 'bubble'),
            array('linear-icon-bubbles' => 'bubbles'),
            array('linear-icon-bubble-dots' => 'bubble-dots'),
            array('linear-icon-bubble-alert' => 'bubble-alert'),
            array('linear-icon-bubble-question' => 'bubble-question'),
            array('linear-icon-bubble-text' => 'bubble-text'),
            array('linear-icon-bubble-pencil' => 'bubble-pencil'),
            array('linear-icon-bubble-picture' => 'bubble-picture'),
            array('linear-icon-bubble-video' => 'bubble-video'),
            array('linear-icon-bubble-user' => 'bubble-user'),
            array('linear-icon-bubble-quote' => 'bubble-quote'),
            array('linear-icon-bubble-heart' => 'bubble-heart'),
            array('linear-icon-bubble-emoticon' => 'bubble-emoticon'),
            array('linear-icon-bubble-attachment' => 'bubble-attachment'),
            array('linear-icon-phone-bubble' => 'phone-bubble'),
            array('linear-icon-quote-open' => 'quote-open'),
            array('linear-icon-quote-close' => 'quote-close'),
            array('linear-icon-dna' => 'dna'),
            array('linear-icon-heart-pulse' => 'heart-pulse'),
            array('linear-icon-pulse' => 'pulse'),
            array('linear-icon-syringe' => 'syringe'),
            array('linear-icon-pills' => 'pills'),
            array('linear-icon-first-aid' => 'first-aid'),
            array('linear-icon-lifebuoy' => 'lifebuoy'),
            array('linear-icon-bandage' => 'bandage'),
            array('linear-icon-bandages' => 'bandages'),
            array('linear-icon-thermometer' => 'thermometer'),
            array('linear-icon-microscope' => 'microscope'),
            array('linear-icon-brain' => 'brain'),
            array('linear-icon-beaker' => 'beaker'),
            array('linear-icon-skull' => 'skull'),
            array('linear-icon-bone' => 'bone'),
            array('linear-icon-construction' => 'construction'),
            array('linear-icon-construction-cone' => 'construction-cone'),
            array('linear-icon-pie-chart' => 'pie-chart'),
            array('linear-icon-pie-chart2' => 'pie-chart2'),
            array('linear-icon-graph' => 'graph'),
            array('linear-icon-chart-growth' => 'chart-growth'),
            array('linear-icon-chart-bars' => 'chart-bars'),
            array('linear-icon-chart-settings' => 'chart-settings'),
            array('linear-icon-cake' => 'cake'),
            array('linear-icon-gift' => 'gift'),
            array('linear-icon-balloon' => 'balloon'),
            array('linear-icon-rank' => 'rank'),
            array('linear-icon-rank2' => 'rank2'),
            array('linear-icon-rank3' => 'rank3'),
            array('linear-icon-crown' => 'crown'),
            array('linear-icon-lotus' => 'lotus'),
            array('linear-icon-diamond' => 'diamond'),
            array('linear-icon-diamond2' => 'diamond2'),
            array('linear-icon-diamond3' => 'diamond3'),
            array('linear-icon-diamond4' => 'diamond4'),
            array('linear-icon-linearicons' => 'linearicons'),
            array('linear-icon-teacup' => 'teacup'),
            array('linear-icon-teapot' => 'teapot'),
            array('linear-icon-glass' => 'glass'),
            array('linear-icon-bottle2' => 'bottle2'),
            array('linear-icon-glass-cocktail' => 'glass-cocktail'),
            array('linear-icon-glass2' => 'glass2'),
            array('linear-icon-dinner' => 'dinner'),
            array('linear-icon-dinner2' => 'dinner2'),
            array('linear-icon-chef' => 'chef'),
            array('linear-icon-scale2' => 'scale2'),
            array('linear-icon-egg' => 'egg'),
            array('linear-icon-egg2' => 'egg2'),
            array('linear-icon-eggs' => 'eggs'),
            array('linear-icon-platter' => 'platter'),
            array('linear-icon-steak' => 'steak'),
            array('linear-icon-hamburger' => 'hamburger'),
            array('linear-icon-hotdog' => 'hotdog'),
            array('linear-icon-pizza' => 'pizza'),
            array('linear-icon-sausage' => 'sausage'),
            array('linear-icon-chicken' => 'chicken'),
            array('linear-icon-fish' => 'fish'),
            array('linear-icon-carrot' => 'carrot'),
            array('linear-icon-cheese' => 'cheese'),
            array('linear-icon-bread' => 'bread'),
            array('linear-icon-ice-cream' => 'ice-cream'),
            array('linear-icon-ice-cream2' => 'ice-cream2'),
            array('linear-icon-candy' => 'candy'),
            array('linear-icon-lollipop' => 'lollipop'),
            array('linear-icon-coffee-bean' => 'coffee-bean'),
            array('linear-icon-coffee-cup' => 'coffee-cup'),
            array('linear-icon-cherry' => 'cherry'),
            array('linear-icon-grapes' => 'grapes'),
            array('linear-icon-citrus' => 'citrus'),
            array('linear-icon-apple' => 'apple'),
            array('linear-icon-leaf' => 'leaf'),
            array('linear-icon-landscape' => 'landscape'),
            array('linear-icon-pine-tree' => 'pine-tree'),
            array('linear-icon-tree' => 'tree'),
            array('linear-icon-cactus' => 'cactus'),
            array('linear-icon-paw' => 'paw'),
            array('linear-icon-footprint' => 'footprint'),
            array('linear-icon-speed-slow' => 'speed-slow'),
            array('linear-icon-speed-medium' => 'speed-medium'),
            array('linear-icon-speed-fast' => 'speed-fast'),
            array('linear-icon-rocket' => 'rocket'),
            array('linear-icon-hammer2' => 'hammer2'),
            array('linear-icon-balance' => 'balance'),
            array('linear-icon-briefcase' => 'briefcase'),
            array('linear-icon-luggage-weight' => 'luggage-weight'),
            array('linear-icon-dolly' => 'dolly'),
            array('linear-icon-plane' => 'plane'),
            array('linear-icon-plane-crossed' => 'plane-crossed'),
            array('linear-icon-helicopter' => 'helicopter'),
            array('linear-icon-traffic-lights' => 'traffic-lights'),
            array('linear-icon-siren' => 'siren'),
            array('linear-icon-road' => 'road'),
            array('linear-icon-engine' => 'engine'),
            array('linear-icon-oil-pressure' => 'oil-pressure'),
            array('linear-icon-coolant-temperature' => 'coolant-temperature'),
            array('linear-icon-car-battery' => 'car-battery'),
            array('linear-icon-gas' => 'gas'),
            array('linear-icon-gallon' => 'gallon'),
            array('linear-icon-transmission' => 'transmission'),
            array('linear-icon-car' => 'car'),
            array('linear-icon-car-wash' => 'car-wash'),
            array('linear-icon-car-wash2' => 'car-wash2'),
            array('linear-icon-bus' => 'bus'),
            array('linear-icon-bus2' => 'bus2'),
            array('linear-icon-car2' => 'car2'),
            array('linear-icon-parking' => 'parking'),
            array('linear-icon-car-lock' => 'car-lock'),
            array('linear-icon-taxi' => 'taxi'),
            array('linear-icon-car-siren' => 'car-siren'),
            array('linear-icon-car-wash3' => 'car-wash3'),
            array('linear-icon-car-wash4' => 'car-wash4'),
            array('linear-icon-ambulance' => 'ambulance'),
            array('linear-icon-truck' => 'truck'),
            array('linear-icon-trailer' => 'trailer'),
            array('linear-icon-scale-truck' => 'scale-truck'),
            array('linear-icon-train' => 'train'),
            array('linear-icon-ship' => 'ship'),
            array('linear-icon-ship2' => 'ship2'),
            array('linear-icon-anchor' => 'anchor'),
            array('linear-icon-boat' => 'boat'),
            array('linear-icon-bicycle' => 'bicycle'),
            array('linear-icon-bicycle2' => 'bicycle2'),
            array('linear-icon-dumbbell' => 'dumbbell'),
            array('linear-icon-bench-press' => 'bench-press'),
            array('linear-icon-swim' => 'swim'),
            array('linear-icon-football' => 'football'),
            array('linear-icon-baseball-bat' => 'baseball-bat'),
            array('linear-icon-baseball' => 'baseball'),
            array('linear-icon-tennis' => 'tennis'),
            array('linear-icon-tennis2' => 'tennis2'),
            array('linear-icon-ping-pong' => 'ping-pong'),
            array('linear-icon-hockey' => 'hockey'),
            array('linear-icon-8ball' => '8ball'),
            array('linear-icon-bowling' => 'bowling'),
            array('linear-icon-bowling-pins' => 'bowling-pins'),
            array('linear-icon-golf' => 'golf'),
            array('linear-icon-golf2' => 'golf2'),
            array('linear-icon-archery' => 'archery'),
            array('linear-icon-slingshot' => 'slingshot'),
            array('linear-icon-soccer' => 'soccer'),
            array('linear-icon-basketball' => 'basketball'),
            array('linear-icon-cube' => 'cube'),
            array('linear-icon-3d-rotate' => '3d-rotate'),
            array('linear-icon-puzzle' => 'puzzle'),
            array('linear-icon-glasses' => 'glasses'),
            array('linear-icon-glasses2' => 'glasses2'),
            array('linear-icon-accessibility' => 'accessibility'),
            array('linear-icon-wheelchair' => 'wheelchair'),
            array('linear-icon-wall' => 'wall'),
            array('linear-icon-fence' => 'fence'),
            array('linear-icon-wall2' => 'wall2'),
            array('linear-icon-icons' => 'icons'),
            array('linear-icon-resize-handle' => 'resize-handle'),
            array('linear-icon-icons2' => 'icons2'),
            array('linear-icon-select' => 'select'),
            array('linear-icon-select2' => 'select2'),
            array('linear-icon-site-map' => 'site-map'),
            array('linear-icon-earth' => 'earth'),
            array('linear-icon-earth-lock' => 'earth-lock'),
            array('linear-icon-network' => 'network'),
            array('linear-icon-network-lock' => 'network-lock'),
            array('linear-icon-planet' => 'planet'),
            array('linear-icon-happy' => 'happy'),
            array('linear-icon-smile' => 'smile'),
            array('linear-icon-grin' => 'grin'),
            array('linear-icon-tongue' => 'tongue'),
            array('linear-icon-sad' => 'sad'),
            array('linear-icon-wink' => 'wink'),
            array('linear-icon-dream' => 'dream'),
            array('linear-icon-shocked' => 'shocked'),
            array('linear-icon-shocked2' => 'shocked2'),
            array('linear-icon-tongue2' => 'tongue2'),
            array('linear-icon-neutral' => 'neutral'),
            array('linear-icon-happy-grin' => 'happy-grin'),
            array('linear-icon-cool' => 'cool'),
            array('linear-icon-mad' => 'mad'),
            array('linear-icon-grin-evil' => 'grin-evil'),
            array('linear-icon-evil' => 'evil'),
            array('linear-icon-wow' => 'wow'),
            array('linear-icon-annoyed' => 'annoyed'),
            array('linear-icon-wondering' => 'wondering'),
            array('linear-icon-confused' => 'confused'),
            array('linear-icon-zipped' => 'zipped'),
            array('linear-icon-grumpy' => 'grumpy'),
            array('linear-icon-mustache' => 'mustache'),
            array('linear-icon-tombstone-hipster' => 'tombstone-hipster'),
            array('linear-icon-tombstone' => 'tombstone'),
            array('linear-icon-ghost' => 'ghost'),
            array('linear-icon-ghost-hipster' => 'ghost-hipster'),
            array('linear-icon-halloween' => 'halloween'),
            array('linear-icon-christmas' => 'christmas'),
            array('linear-icon-easter-egg' => 'easter-egg'),
            array('linear-icon-mustache2' => 'mustache2'),
            array('linear-icon-mustache-glasses' => 'mustache-glasses'),
            array('linear-icon-pipe' => 'pipe'),
            array('linear-icon-alarm' => 'alarm'),
            array('linear-icon-alarm-add' => 'alarm-add'),
            array('linear-icon-alarm-snooze' => 'alarm-snooze'),
            array('linear-icon-alarm-ringing' => 'alarm-ringing'),
            array('linear-icon-bullhorn' => 'bullhorn'),
            array('linear-icon-hearing' => 'hearing'),
            array('linear-icon-volume-high' => 'volume-high'),
            array('linear-icon-volume-medium' => 'volume-medium'),
            array('linear-icon-volume-low' => 'volume-low'),
            array('linear-icon-volume' => 'volume'),
            array('linear-icon-mute' => 'mute'),
            array('linear-icon-lan' => 'lan'),
            array('linear-icon-lan2' => 'lan2'),
            array('linear-icon-wifi' => 'wifi'),
            array('linear-icon-wifi-lock' => 'wifi-lock'),
            array('linear-icon-wifi-blocked' => 'wifi-blocked'),
            array('linear-icon-wifi-mid' => 'wifi-mid'),
            array('linear-icon-wifi-low' => 'wifi-low'),
            array('linear-icon-wifi-low2' => 'wifi-low2'),
            array('linear-icon-wifi-alert' => 'wifi-alert'),
            array('linear-icon-wifi-alert-mid' => 'wifi-alert-mid'),
            array('linear-icon-wifi-alert-low' => 'wifi-alert-low'),
            array('linear-icon-wifi-alert-low2' => 'wifi-alert-low2'),
            array('linear-icon-stream' => 'stream'),
            array('linear-icon-stream-check' => 'stream-check'),
            array('linear-icon-stream-error' => 'stream-error'),
            array('linear-icon-stream-alert' => 'stream-alert'),
            array('linear-icon-communication' => 'communication'),
            array('linear-icon-communication-crossed' => 'communication-crossed'),
            array('linear-icon-broadcast' => 'broadcast'),
            array('linear-icon-antenna' => 'antenna'),
            array('linear-icon-satellite' => 'satellite'),
            array('linear-icon-satellite2' => 'satellite2'),
            array('linear-icon-mic' => 'mic'),
            array('linear-icon-mic-mute' => 'mic-mute'),
            array('linear-icon-mic2' => 'mic2'),
            array('linear-icon-spotlights' => 'spotlights'),
            array('linear-icon-hourglass' => 'hourglass'),
            array('linear-icon-loading' => 'loading'),
            array('linear-icon-loading2' => 'loading2'),
            array('linear-icon-loading3' => 'loading3'),
            array('linear-icon-refresh' => 'refresh'),
            array('linear-icon-refresh2' => 'refresh2'),
            array('linear-icon-undo' => 'undo'),
            array('linear-icon-redo' => 'redo'),
            array('linear-icon-jump2' => 'jump2'),
            array('linear-icon-undo2' => 'undo2'),
            array('linear-icon-redo2' => 'redo2'),
            array('linear-icon-sync' => 'sync'),
            array('linear-icon-repeat-one2' => 'repeat-one2'),
            array('linear-icon-sync-crossed' => 'sync-crossed'),
            array('linear-icon-sync2' => 'sync2'),
            array('linear-icon-repeat-one3' => 'repeat-one3'),
            array('linear-icon-sync-crossed2' => 'sync-crossed2'),
            array('linear-icon-return' => 'return'),
            array('linear-icon-return2' => 'return2'),
            array('linear-icon-refund' => 'refund'),
            array('linear-icon-history' => 'history'),
            array('linear-icon-history2' => 'history2'),
            array('linear-icon-self-timer' => 'self-timer'),
            array('linear-icon-clock' => 'clock'),
            array('linear-icon-clock2' => 'clock2'),
            array('linear-icon-clock3' => 'clock3'),
            array('linear-icon-watch' => 'watch'),
            array('linear-icon-alarm2' => 'alarm2'),
            array('linear-icon-alarm-add2' => 'alarm-add2'),
            array('linear-icon-alarm-remove' => 'alarm-remove'),
            array('linear-icon-alarm-check' => 'alarm-check'),
            array('linear-icon-alarm-error' => 'alarm-error'),
            array('linear-icon-timer' => 'timer'),
            array('linear-icon-timer-crossed' => 'timer-crossed'),
            array('linear-icon-timer2' => 'timer2'),
            array('linear-icon-timer-crossed2' => 'timer-crossed2'),
            array('linear-icon-download' => 'download'),
            array('linear-icon-upload' => 'upload'),
            array('linear-icon-download2' => 'download2'),
            array('linear-icon-upload2' => 'upload2'),
            array('linear-icon-enter-up' => 'enter-up'),
            array('linear-icon-enter-down' => 'enter-down'),
            array('linear-icon-enter-left' => 'enter-left'),
            array('linear-icon-enter-right' => 'enter-right'),
            array('linear-icon-exit-up' => 'exit-up'),
            array('linear-icon-exit-down' => 'exit-down'),
            array('linear-icon-exit-left' => 'exit-left'),
            array('linear-icon-exit-right' => 'exit-right'),
            array('linear-icon-enter-up2' => 'enter-up2'),
            array('linear-icon-enter-down2' => 'enter-down2'),
            array('linear-icon-enter-vertical' => 'enter-vertical'),
            array('linear-icon-enter-left2' => 'enter-left2'),
            array('linear-icon-enter-right2' => 'enter-right2'),
            array('linear-icon-enter-horizontal' => 'enter-horizontal'),
            array('linear-icon-exit-up2' => 'exit-up2'),
            array('linear-icon-exit-down2' => 'exit-down2'),
            array('linear-icon-exit-left2' => 'exit-left2'),
            array('linear-icon-exit-right2' => 'exit-right2'),
            array('linear-icon-cli' => 'cli'),
            array('linear-icon-bug' => 'bug'),
            array('linear-icon-code' => 'code'),
            array('linear-icon-file-code' => 'file-code'),
            array('linear-icon-file-image' => 'file-image'),
            array('linear-icon-file-zip' => 'file-zip'),
            array('linear-icon-file-audio' => 'file-audio'),
            array('linear-icon-file-video' => 'file-video'),
            array('linear-icon-file-preview' => 'file-preview'),
            array('linear-icon-file-charts' => 'file-charts'),
            array('linear-icon-file-stats' => 'file-stats'),
            array('linear-icon-file-spreadsheet' => 'file-spreadsheet'),
            array('linear-icon-link' => 'link'),
            array('linear-icon-unlink' => 'unlink'),
            array('linear-icon-link2' => 'link2'),
            array('linear-icon-unlink2' => 'unlink2'),
            array('linear-icon-thumbs-up' => 'thumbs-up'),
            array('linear-icon-thumbs-down' => 'thumbs-down'),
            array('linear-icon-thumbs-up2' => 'thumbs-up2'),
            array('linear-icon-thumbs-down2' => 'thumbs-down2'),
            array('linear-icon-thumbs-up3' => 'thumbs-up3'),
            array('linear-icon-thumbs-down3' => 'thumbs-down3'),
            array('linear-icon-share' => 'share'),
            array('linear-icon-share2' => 'share2'),
            array('linear-icon-share3' => 'share3'),
            array('linear-icon-magnifier' => 'magnifier'),
            array('linear-icon-file-search' => 'file-search'),
            array('linear-icon-find-replace' => 'find-replace'),
            array('linear-icon-zoom-in' => 'zoom-in'),
            array('linear-icon-zoom-out' => 'zoom-out'),
            array('linear-icon-loupe' => 'loupe'),
            array('linear-icon-loupe-zoom-in' => 'loupe-zoom-in'),
            array('linear-icon-loupe-zoom-out' => 'loupe-zoom-out'),
            array('linear-icon-cross' => 'cross'),
            array('linear-icon-menu' => 'menu'),
            array('linear-icon-list' => 'list'),
            array('linear-icon-list2' => 'list2'),
            array('linear-icon-list3' => 'list3'),
            array('linear-icon-menu2' => 'menu2'),
            array('linear-icon-list4' => 'list4'),
            array('linear-icon-menu3' => 'menu3'),
            array('linear-icon-exclamation' => 'exclamation'),
            array('linear-icon-question' => 'question'),
            array('linear-icon-check' => 'check'),
            array('linear-icon-cross2' => 'cross2'),
            array('linear-icon-plus' => 'plus'),
            array('linear-icon-minus' => 'minus'),
            array('linear-icon-percent' => 'percent'),
            array('linear-icon-chevron-up' => 'chevron-up'),
            array('linear-icon-chevron-down' => 'chevron-down'),
            array('linear-icon-chevron-left' => 'chevron-left'),
            array('linear-icon-chevron-right' => 'chevron-right'),
            array('linear-icon-chevrons-expand-vertical' => 'chevrons-expand-vertical'),
            array('linear-icon-chevrons-expand-horizontal' => 'chevrons-expand-horizontal'),
            array('linear-icon-chevrons-contract-vertical' => 'chevrons-contract-vertical'),
            array('linear-icon-chevrons-contract-horizontal' => 'chevrons-contract-horizontal'),
            array('linear-icon-arrow-up' => 'arrow-up'),
            array('linear-icon-arrow-down' => 'arrow-down'),
            array('linear-icon-arrow-left' => 'arrow-left'),
            array('linear-icon-arrow-right' => 'arrow-right'),
            array('linear-icon-arrow-up-right' => 'arrow-up-right'),
            array('linear-icon-arrows-merge' => 'arrows-merge'),
            array('linear-icon-arrows-split' => 'arrows-split'),
            array('linear-icon-arrow-divert' => 'arrow-divert'),
            array('linear-icon-arrow-return' => 'arrow-return'),
            array('linear-icon-expand' => 'expand'),
            array('linear-icon-contract' => 'contract'),
            array('linear-icon-expand2' => 'expand2'),
            array('linear-icon-contract2' => 'contract2'),
            array('linear-icon-move' => 'move'),
            array('linear-icon-tab' => 'tab'),
            array('linear-icon-arrow-wave' => 'arrow-wave'),
            array('linear-icon-expand3' => 'expand3'),
            array('linear-icon-expand4' => 'expand4'),
            array('linear-icon-contract3' => 'contract3'),
            array('linear-icon-notification' => 'notification'),
            array('linear-icon-warning' => 'warning'),
            array('linear-icon-notification-circle' => 'notification-circle'),
            array('linear-icon-question-circle' => 'question-circle'),
            array('linear-icon-menu-circle' => 'menu-circle'),
            array('linear-icon-checkmark-circle' => 'checkmark-circle'),
            array('linear-icon-cross-circle' => 'cross-circle'),
            array('linear-icon-plus-circle' => 'plus-circle'),
            array('linear-icon-circle-minus' => 'circle-minus'),
            array('linear-icon-percent-circle' => 'percent-circle'),
            array('linear-icon-arrow-up-circle' => 'arrow-up-circle'),
            array('linear-icon-arrow-down-circle' => 'arrow-down-circle'),
            array('linear-icon-arrow-left-circle' => 'arrow-left-circle'),
            array('linear-icon-arrow-right-circle' => 'arrow-right-circle'),
            array('linear-icon-chevron-up-circle' => 'chevron-up-circle'),
            array('linear-icon-chevron-down-circle' => 'chevron-down-circle'),
            array('linear-icon-chevron-left-circle' => 'chevron-left-circle'),
            array('linear-icon-chevron-right-circle' => 'chevron-right-circle'),
            array('linear-icon-backward-circle' => 'backward-circle'),
            array('linear-icon-first-circle' => 'first-circle'),
            array('linear-icon-previous-circle' => 'previous-circle'),
            array('linear-icon-stop-circle' => 'stop-circle'),
            array('linear-icon-play-circle' => 'play-circle'),
            array('linear-icon-pause-circle' => 'pause-circle'),
            array('linear-icon-next-circle' => 'next-circle'),
            array('linear-icon-last-circle' => 'last-circle'),
            array('linear-icon-forward-circle' => 'forward-circle'),
            array('linear-icon-eject-circle' => 'eject-circle'),
            array('linear-icon-crop' => 'crop'),
            array('linear-icon-frame-expand' => 'frame-expand'),
            array('linear-icon-frame-contract' => 'frame-contract'),
            array('linear-icon-focus' => 'focus'),
            array('linear-icon-transform' => 'transform'),
            array('linear-icon-grid' => 'grid'),
            array('linear-icon-grid-crossed' => 'grid-crossed'),
            array('linear-icon-layers' => 'layers'),
            array('linear-icon-layers-crossed' => 'layers-crossed'),
            array('linear-icon-toggle' => 'toggle'),
            array('linear-icon-rulers' => 'rulers'),
            array('linear-icon-ruler' => 'ruler'),
            array('linear-icon-funnel' => 'funnel'),
            array('linear-icon-flip-horizontal' => 'flip-horizontal'),
            array('linear-icon-flip-vertical' => 'flip-vertical'),
            array('linear-icon-flip-horizontal2' => 'flip-horizontal2'),
            array('linear-icon-flip-vertical2' => 'flip-vertical2'),
            array('linear-icon-angle' => 'angle'),
            array('linear-icon-angle2' => 'angle2'),
            array('linear-icon-subtract' => 'subtract'),
            array('linear-icon-combine' => 'combine'),
            array('linear-icon-intersect' => 'intersect'),
            array('linear-icon-exclude' => 'exclude'),
            array('linear-icon-align-center-vertical' => 'align-center-vertical'),
            array('linear-icon-align-right' => 'align-right'),
            array('linear-icon-align-bottom' => 'align-bottom'),
            array('linear-icon-align-left' => 'align-left'),
            array('linear-icon-align-center-horizontal' => 'align-center-horizontal'),
            array('linear-icon-align-top' => 'align-top'),
            array('linear-icon-square' => 'square'),
            array('linear-icon-plus-square' => 'plus-square'),
            array('linear-icon-minus-square' => 'minus-square'),
            array('linear-icon-percent-square' => 'percent-square'),
            array('linear-icon-arrow-up-square' => 'arrow-up-square'),
            array('linear-icon-arrow-down-square' => 'arrow-down-square'),
            array('linear-icon-arrow-left-square' => 'arrow-left-square'),
            array('linear-icon-arrow-right-square' => 'arrow-right-square'),
            array('linear-icon-chevron-up-square' => 'chevron-up-square'),
            array('linear-icon-chevron-down-square' => 'chevron-down-square'),
            array('linear-icon-chevron-left-square' => 'chevron-left-square'),
            array('linear-icon-chevron-right-square' => 'chevron-right-square'),
            array('linear-icon-check-square' => 'check-square'),
            array('linear-icon-cross-square' => 'cross-square'),
            array('linear-icon-menu-square' => 'menu-square'),
            array('linear-icon-prohibited' => 'prohibited'),
            array('linear-icon-circle' => 'circle'),
            array('linear-icon-radio-button' => 'radio-button'),
            array('linear-icon-ligature' => 'ligature'),
            array('linear-icon-text-format' => 'text-format'),
            array('linear-icon-text-format-remove' => 'text-format-remove'),
            array('linear-icon-text-size' => 'text-size'),
            array('linear-icon-bold' => 'bold'),
            array('linear-icon-italic' => 'italic'),
            array('linear-icon-underline' => 'underline'),
            array('linear-icon-strikethrough' => 'strikethrough'),
            array('linear-icon-highlight' => 'highlight'),
            array('linear-icon-text-align-left' => 'text-align-left'),
            array('linear-icon-text-align-center' => 'text-align-center'),
            array('linear-icon-text-align-right' => 'text-align-right'),
            array('linear-icon-text-align-justify' => 'text-align-justify'),
            array('linear-icon-line-spacing' => 'line-spacing'),
            array('linear-icon-indent-increase' => 'indent-increase'),
            array('linear-icon-indent-decrease' => 'indent-decrease'),
            array('linear-icon-text-wrap' => 'text-wrap'),
            array('linear-icon-pilcrow' => 'pilcrow'),
            array('linear-icon-direction-ltr' => 'direction-ltr'),
            array('linear-icon-direction-rtl' => 'direction-rtl'),
            array('linear-icon-page-break' => 'page-break'),
            array('linear-icon-page-break2' => 'page-break2'),
            array('linear-icon-sort-alpha-asc' => 'sort-alpha-asc'),
            array('linear-icon-sort-alpha-desc' => 'sort-alpha-desc'),
            array('linear-icon-sort-numeric-asc' => 'sort-numeric-asc'),
            array('linear-icon-sort-numeric-desc' => 'sort-numeric-desc'),
            array('linear-icon-sort-amount-asc' => 'sort-amount-asc'),
            array('linear-icon-sort-amount-desc' => 'sort-amount-desc'),
            array('linear-icon-sort-time-asc' => 'sort-time-asc'),
            array('linear-icon-sort-time-desc' => 'sort-time-desc'),
            array('linear-icon-sigma' => 'sigma'),
            array('linear-icon-pencil-line' => 'pencil-line'),
            array('linear-icon-hand' => 'hand'),
            array('linear-icon-pointer-up' => 'pointer-up'),
            array('linear-icon-pointer-right' => 'pointer-right'),
            array('linear-icon-pointer-down' => 'pointer-down'),
            array('linear-icon-pointer-left' => 'pointer-left'),
            array('linear-icon-finger-tap' => 'finger-tap'),
            array('linear-icon-fingers-tap' => 'fingers-tap'),
            array('linear-icon-reminder' => 'reminder'),
            array('linear-icon-fingers-crossed' => 'fingers-crossed'),
            array('linear-icon-fingers-victory' => 'fingers-victory'),
            array('linear-icon-gesture-zoom' => 'gesture-zoom'),
            array('linear-icon-gesture-pinch' => 'gesture-pinch'),
            array('linear-icon-fingers-scroll-horizontal' => 'fingers-scroll-horizontal'),
            array('linear-icon-fingers-scroll-vertical' => 'fingers-scroll-vertical'),
            array('linear-icon-fingers-scroll-left' => 'fingers-scroll-left'),
            array('linear-icon-fingers-scroll-right' => 'fingers-scroll-right'),
            array('linear-icon-hand2' => 'hand2'),
            array('linear-icon-pointer-up2' => 'pointer-up2'),
            array('linear-icon-pointer-right2' => 'pointer-right2'),
            array('linear-icon-pointer-down2' => 'pointer-down2'),
            array('linear-icon-pointer-left2' => 'pointer-left2'),
            array('linear-icon-finger-tap2' => 'finger-tap2'),
            array('linear-icon-fingers-tap2' => 'fingers-tap2'),
            array('linear-icon-reminder2' => 'reminder2'),
            array('linear-icon-gesture-zoom2' => 'gesture-zoom2'),
            array('linear-icon-gesture-pinch2' => 'gesture-pinch2'),
            array('linear-icon-fingers-scroll-horizontal2' => 'fingers-scroll-horizontal2'),
            array('linear-icon-fingers-scroll-vertical2' => 'fingers-scroll-vertical2'),
            array('linear-icon-fingers-scroll-left2' => 'fingers-scroll-left2'),
            array('linear-icon-fingers-scroll-right2' => 'fingers-scroll-right2'),
            array('linear-icon-fingers-scroll-vertical3' => 'fingers-scroll-vertical3'),
            array('linear-icon-border-style' => 'border-style'),
            array('linear-icon-border-all' => 'border-all'),
            array('linear-icon-border-outer' => 'border-outer'),
            array('linear-icon-border-inner' => 'border-inner'),
            array('linear-icon-border-top' => 'border-top'),
            array('linear-icon-border-horizontal' => 'border-horizontal'),
            array('linear-icon-border-bottom' => 'border-bottom'),
            array('linear-icon-border-left' => 'border-left'),
            array('linear-icon-border-vertical' => 'border-vertical'),
            array('linear-icon-border-right' => 'border-right'),
            array('linear-icon-border-none' => 'border-none'),
            array('linear-icon-ellipsis' => 'ellipsis')
        );
    }
    add_filter( 'vc_iconpicker-type-linearicons', 'urna_tbay_linearicons_array' );
}

if ( !function_exists('urna_tbay_vc_iconpicker_base_register_css')) {
    /**
     * Register Backend and Frontend CSS Styles
     */
    add_action( 'vc_base_register_front_css', 'urna_tbay_vc_iconpicker_base_register_css' );
    add_action( 'vc_base_register_admin_css', 'urna_tbay_vc_iconpicker_base_register_css' );
    function urna_tbay_vc_iconpicker_base_register_css(){
        wp_register_style( 'simple-line-icons', URNA_STYLES . '/simple-line-icons.css', array(), '2.4.0' );
        wp_register_style( 'linearicons', URNA_STYLES . '/linearicons.css', array(), '1.0.0' );
    }
}

if ( !function_exists('urna_tbay_vc_iconpicker_editor_jscss')) {
    /**
     * Enqueue Backend and Frontend CSS Styles
     */
    add_action( 'vc_backend_editor_enqueue_js_css', 'urna_tbay_vc_iconpicker_editor_jscss' );
    add_action( 'vc_frontend_editor_enqueue_js_css', 'urna_tbay_vc_iconpicker_editor_jscss' );
    function urna_tbay_vc_iconpicker_editor_jscss(){
        wp_enqueue_style( 'simple-line-icons' );
        wp_enqueue_style( 'linearicons' );
        wp_deregister_style( 'font-awesome' );
        wp_enqueue_style( 'font-awesome', URNA_STYLES . '/font-awesome.css', array(), '4.7.0' );
    }
}

if ( !function_exists('urna_tbay_enqueue_font_icomoon')) {
    /**
     * Enqueue CSS in Frontend when it's used
     */
    add_action('vc_enqueue_font_icon_element', 'urna_tbay_enqueue_font_icomoon');
    function urna_tbay_enqueue_font_icomoon($font){
        switch ( $font ) {
            case 'simpleline': wp_enqueue_style( 'simple-line-icons' );
            case 'linearicons': wp_enqueue_style( 'linearicons' );
        }
    }
}